/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.cassandra;

import com.adventnet.wms.servercommon.cassandra.datastax.DatastaxManager;
import com.adventnet.wms.servercommon.counters.RangeCounter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class CassandraStats {
    public static final String PUT = "put";
    public static final String GET = "get";
    public static final String DEL = "del";
    public static final String INCR = "incr";
    private static AtomicLong total = new AtomicLong(0L);
    private static ConcurrentHashMap<String, AtomicLong> totalOps = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, CFStats> cf = new ConcurrentHashMap();

    public static Object start(String opr, String cfname) {
        if (DatastaxManager.getStatsHandler() != null) {
            return DatastaxManager.getStatsHandler().handleStart(cfname, opr);
        }
        return null;
    }

    public static void hit(String opr, String cfname, long startTime, Object reference) {
        CassandraStats.hit(opr, cfname, startTime, true, reference);
    }

    public static void hitFailure(String opr, String cfname, long startTime, Object reference) {
        CassandraStats.hit(opr, cfname, startTime, false, reference);
    }

    public static void hit(String opr, String cfname, long startTime, boolean success, Object reference) {
        long duration = System.currentTimeMillis() - startTime;
        total.incrementAndGet();
        AtomicLong oprCounter = totalOps.get(opr);
        if (oprCounter == null) {
            oprCounter = new AtomicLong(0L);
            totalOps.put(opr, oprCounter);
        }
        oprCounter.incrementAndGet();
        CFStats cfstats = cf.get(cfname);
        if (cfstats == null) {
            cfstats = new CFStats(cfname);
            cf.put(cfname, cfstats);
        }
        cfstats.hit(opr, duration);
        if (DatastaxManager.getStatsHandler() != null) {
            DatastaxManager.getStatsHandler().handleHit(cfname, opr);
            DatastaxManager.getStatsHandler().handleComplete(cfname, opr, duration, success, reference);
        }
    }

    public static Hashtable getStats() {
        Hashtable<String, Serializable> stats = new Hashtable<String, Serializable>();
        stats.put("totalSummary", total);
        Hashtable<String, Long> opsMap = new Hashtable<String, Long>();
        stats.put("opsSummary", opsMap);
        Enumeration<String> e = totalOps.keys();
        while (e.hasMoreElements()) {
            String opr = e.nextElement();
            opsMap.put(opr, totalOps.get(opr).get());
        }
        Hashtable<String, Hashtable> cfMap = new Hashtable<String, Hashtable>();
        stats.put("cf", cfMap);
        Enumeration<String> e2 = cf.keys();
        while (e2.hasMoreElements()) {
            String cfname = e2.nextElement();
            cfMap.put(cfname, cf.get(cfname).getStats());
        }
        return stats;
    }

    public static void reset() {
        total.set(0L);
        totalOps = new ConcurrentHashMap();
        Enumeration<CFStats> e = cf.elements();
        while (e.hasMoreElements()) {
            e.nextElement().reset();
        }
    }

    static class CFStats {
        private String cfname;
        private AtomicLong allOps = new AtomicLong(0L);
        private ConcurrentHashMap<String, RangeCounter> ops = new ConcurrentHashMap();
        private long cfMaxRate;
        private long cfMaxRateTime;

        public CFStats(String cfname) {
            this.cfname = cfname;
            this.cfMaxRate = 0L;
            this.cfMaxRateTime = System.currentTimeMillis();
        }

        public void hit(String opr, long duration) {
            this.allOps.incrementAndGet();
            duration = duration < 0L ? 0L : duration;
            RangeCounter counter = this.ops.get(opr);
            if (counter == null) {
                counter = new RangeCounter(10L, 1000L);
                this.ops.put(opr, counter);
            }
            counter.add(duration);
        }

        public Hashtable getStats() {
            Hashtable<String, Serializable> stats = new Hashtable<String, Serializable>();
            stats.put("total", this.allOps);
            stats.put("maxRate", Long.valueOf(this.cfMaxRate));
            stats.put("maxRateTime", Long.valueOf(this.cfMaxRateTime));
            Hashtable<String, Hashtable> dbops = new Hashtable<String, Hashtable>();
            stats.put("ops", dbops);
            Enumeration<String> e = this.ops.keys();
            while (e.hasMoreElements()) {
                String opr = e.nextElement();
                dbops.put(opr, this.ops.get(opr).getHash());
            }
            return stats;
        }

        public void reset() {
            this.cfMaxRate = 0L;
            this.cfMaxRateTime = System.currentTimeMillis();
            this.allOps.set(0L);
            Enumeration<RangeCounter> e = this.ops.elements();
            while (e.hasMoreElements()) {
                e.nextElement().reset();
            }
        }
    }
}

