/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon.bbpool;

import com.adventnet.wms.servercommon.bbpool.BBPoolConfManager;
import com.adventnet.wms.servercommon.bbpool.WMSBBPool;
import com.adventnet.wms.servercommon.bbpool.WMSBBPoolUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WMSBBPoolAllocator {
    private static Logger logger = Logger.getLogger(WMSBBPoolAllocator.class.getName());
    private static Hashtable pooltable = new Hashtable();
    private static ConcurrentLinkedQueue<WMSBBPool> freebuff = new ConcurrentLinkedQueue();
    private static ConcurrentLinkedQueue<WMSBBPool> directfreebuff = new ConcurrentLinkedQueue();
    private static Hashtable<String, WMSBBPool> poolmap = new Hashtable();
    private static Hashtable<String, WMSBBPool> directpoolmap = new Hashtable();

    public static void initialize() throws Exception {
        try {
            WMSBBPool bbpool;
            BBPoolConfManager.initialize();
            ArrayList confList = BBPoolConfManager.getBBPoolConfigurations();
            boolean isDirectBB = BBPoolConfManager.isDirectBBPool();
            boolean isBestFitBB = BBPoolConfManager.isBestFitBB();
            for (String conf : confList) {
                String[] confarr = conf.split(":");
                int chunks = Integer.parseInt(confarr[0]);
                int chunksize = Integer.parseInt(confarr[1]);
                WMSBBPool bbpool2 = new WMSBBPool(chunks, chunksize, isDirectBB, isBestFitBB);
                pooltable.put(bbpool2.getMasterBufferHash(), bbpool2);
            }
            if (BBPoolConfManager.isSessionPoolEnabled()) {
                for (int i = 0; i < 10; ++i) {
                    bbpool = new WMSBBPool(BBPoolConfManager.getSessionPoolChunkCount(), BBPoolConfManager.getSessionPoolChunkSize(), false, false);
                    freebuff.add(bbpool);
                }
            }
            if (BBPoolConfManager.isDirectSessionPoolEnabled()) {
                for (int i = 0; i < 10; ++i) {
                    bbpool = new WMSBBPool(BBPoolConfManager.getDirectSessionPoolChunkCount(), BBPoolConfManager.getDirectSessionPoolChunkSize(), true, false);
                    directfreebuff.add(bbpool);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "[WMSBBPoolAllocator][FATAL][ERROR INITIALIZING BB POOL][DISABLING BB POOL]", e);
            BBPoolConfManager.disableBBPool();
            throw e;
        }
    }

    public static boolean setBBPool(boolean isSet) {
        if (isSet) {
            return BBPoolConfManager.enableBBPool();
        }
        return BBPoolConfManager.disableBBPool();
    }

    public static boolean setBestFitBB(boolean isSet) {
        if (isSet) {
            return BBPoolConfManager.enableBestFitBB();
        }
        return BBPoolConfManager.disableBestFitBB();
    }

    public static String getStatus() {
        String res = "isPoolEnabled - " + BBPoolConfManager.isBBPoolEnabled() + " | isDirect - " + BBPoolConfManager.isDirectBBPool() + " | isBestFit - " + BBPoolConfManager.isBestFitBB() + " | Pool Conf - " + BBPoolConfManager.getBBPoolConfigurations();
        return res;
    }

    public static ByteBuffer get(int requiredsize) {
        if (BBPoolConfManager.isBBPoolEnabled()) {
            Iterator itr = pooltable.keySet().iterator();
            while (itr.hasNext()) {
                ByteBuffer resbuff;
                long hash = (Long)itr.next();
                WMSBBPool bbpool = (WMSBBPool)pooltable.get(hash);
                if (!bbpool.checkAllocationGap() || (resbuff = bbpool.get(requiredsize)) == null) continue;
                return resbuff;
            }
        }
        ByteBuffer unpooled = null;
        unpooled = BBPoolConfManager.isDirectBBPool() ? ByteBuffer.allocateDirect(requiredsize) : ByteBuffer.allocate(requiredsize);
        if (requiredsize > 0 && BBPoolConfManager.isBBPoolEnabled()) {
            logger.info("[WMSBBPool ALLOCATOR][FATAL][CAN'T ALLOCATE BUFFER IN POOL][RETURNING UNPOOLED][REQ SIZE][" + requiredsize + "][HASH][" + WMSBBPoolUtil.computeHash(unpooled) + "]");
        }
        return unpooled;
    }

    public static void put(ByteBuffer buffer) {
        if (buffer == null) {
            return;
        }
        long parentHash = WMSBBPoolUtil.getParentHash(buffer);
        if (!pooltable.containsKey(parentHash)) {
            buffer.clear();
            if (buffer.capacity() > 0 && BBPoolConfManager.isBBPoolEnabled()) {
                logger.info("[WMSBBPool ALLOCATOR][FATAL][RETURNING UNPOOLED BUFFER][SIZE][" + buffer.capacity() + "][HASH][" + WMSBBPoolUtil.computeHash(buffer) + "]");
            }
            return;
        }
        WMSBBPool bbpool = (WMSBBPool)pooltable.get(parentHash);
        if (!bbpool.put(buffer)) {
            logger.info("[WMSBBPool ALLOCATOR][FATAL][CANNOT RETURN BUFFER TO THE POOL][HASH][" + parentHash + "][BUFFER][" + buffer + "]");
        }
    }

    public static ByteBuffer get(String key, int reqsize) {
        WMSBBPool pool;
        if (!poolmap.containsKey(key)) {
            pool = freebuff.poll();
            try {
                if (pool == null) {
                    pool = new WMSBBPool(BBPoolConfManager.getSessionPoolChunkCount(), BBPoolConfManager.getSessionPoolChunkSize(), false, false);
                }
                poolmap.put(key, pool);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        pool = poolmap.get(key);
        ByteBuffer resbuff = null;
        if (pool != null && pool.checkAllocationGap()) {
            resbuff = pool.get(reqsize);
        }
        if (resbuff == null) {
            resbuff = ByteBuffer.allocate(reqsize);
        }
        return resbuff;
    }

    public static void put(String key, ByteBuffer buff) {
        if (buff == null) {
            return;
        }
        if (!poolmap.containsKey(key)) {
            buff.clear();
            return;
        }
        WMSBBPool bbpool = poolmap.get(key);
        bbpool.put(buff);
    }

    public static void release(String key) {
        WMSBBPool pool = poolmap.get(key);
        if (pool != null) {
            pool.reset();
            freebuff.add(pool);
        }
    }

    public static ByteBuffer getDirect(String key, int reqsize) {
        WMSBBPool pool;
        if (!directpoolmap.containsKey(key)) {
            pool = directfreebuff.poll();
            try {
                if (pool == null) {
                    pool = new WMSBBPool(BBPoolConfManager.getDirectSessionPoolChunkCount(), BBPoolConfManager.getDirectSessionPoolChunkSize(), false, false);
                }
                directpoolmap.put(key, pool);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        pool = directpoolmap.get(key);
        ByteBuffer resbuff = null;
        if (pool != null && pool.checkAllocationGap()) {
            resbuff = pool.get(reqsize);
        }
        if (resbuff == null) {
            resbuff = ByteBuffer.allocate(reqsize);
        }
        return resbuff;
    }

    public static void putDirect(String key, ByteBuffer buff) {
        if (buff == null) {
            return;
        }
        if (!directpoolmap.containsKey(key)) {
            buff.clear();
            return;
        }
        WMSBBPool bbpool = directpoolmap.get(key);
        bbpool.put(buff);
    }

    public static void releaseDirect(String key) {
        WMSBBPool pool = poolmap.get(key);
        if (pool != null) {
            pool.reset();
            directfreebuff.add(pool);
        }
    }
}

