/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon;

import com.adventnet.wms.common.Base64;
import com.adventnet.wms.common.exception.WMSException;
import com.adventnet.wms.servercommon.util.WmsSecurityUtil;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class WmsSession {
    private String prd;
    private String sid;
    private String wmsid;
    private String config;
    private String orgid;
    private String wsid;
    private String encode_prefix = "NEN";

    public WmsSession(String prd, String sid, String wmsid, String config, String orgid) throws WMSException {
        this.prd = prd;
        this.sid = sid;
        this.wmsid = wmsid;
        this.config = config;
        this.orgid = orgid;
        this.wsid = this.encrypt(prd + ":" + sid + ":" + wmsid + ":" + config + ":" + orgid);
    }

    public WmsSession(String wsid) throws WMSException {
        this.wsid = wsid;
        String[] p = null;
        p = wsid.startsWith(this.encode_prefix) ? this.decrypt(wsid).split(":") : WmsSecurityUtil.decrypt(wsid).split(":");
        if (p == null) {
            throw new WMSException("Problem in decrypting wsid " + wsid);
        }
        this.prd = p[0];
        this.sid = p[1];
        this.wmsid = p[2];
        this.config = p[3];
        this.orgid = p[4];
    }

    public String getWsid() {
        return this.wsid;
    }

    public String getPrd() {
        return this.prd;
    }

    public String getSid() {
        return this.sid;
    }

    public String getWmsid() {
        return this.wmsid;
    }

    public String getConfig() {
        return this.config;
    }

    public String getOrgid() {
        return this.orgid;
    }

    public void setValues(String wmsid, String orgid) throws WMSException {
        if (!wmsid.equals(this.wmsid) || !orgid.equals(this.orgid)) {
            this.wmsid = wmsid;
            this.orgid = orgid;
            this.wsid = this.encrypt(this.prd + ":" + this.sid + ":" + this.wmsid + ":" + this.config + ":" + orgid);
        }
    }

    public void setWmsId(String wmsid) throws WMSException {
        if (!wmsid.equals(this.wmsid)) {
            this.wmsid = wmsid;
            this.wsid = this.encrypt(this.prd + ":" + this.sid + ":" + this.wmsid + ":" + this.config + ":" + this.orgid);
        }
    }

    public void setConfig(String config) throws WMSException {
        if (this.config != config) {
            this.config = config;
            this.wsid = this.encrypt(this.prd + ":" + this.sid + ":" + this.wmsid + ":" + this.config + ":" + this.orgid);
        }
    }

    private String encrypt(String input) {
        String enc = Base64.encode((String)input);
        String result = this.encode_prefix + URLEncoder.encode(enc);
        return result;
    }

    private String decrypt(String input) {
        try {
            input = URLDecoder.decode(input);
            input = input.substring(this.encode_prefix.length());
            return Base64.decode((String)input);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WmsSession)) {
            return false;
        }
        WmsSession ws = (WmsSession)obj;
        return this.prd.equals(ws.getPrd()) && this.sid.equals(ws.getSid()) && this.wmsid.equals(ws.getWmsid()) && this.config.equals(ws.getConfig()) && this.orgid.equals(ws.getOrgid());
    }

    public String toString() {
        return this.prd + ":" + this.sid + ":" + this.wmsid + ":" + this.config + ":" + this.orgid;
    }
}

