/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.servercommon;

import com.adventnet.wms.common.WmsEvent;
import com.adventnet.wms.servercommon.logging.ExternalLogger;
import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Logger;

public class ServerUtil {
    private static Logger logger = Logger.getLogger(ServerUtil.class.getName());
    public static final String serverHome;
    public static final String dataHome;
    public static final String logHome;
    public static int threadPoolCount;
    private static String serverIP;
    private static ExternalLogger eLogger;
    private static String eLoggerFile;

    public static Properties getProperties(String propsFile) {
        try {
            logger.fine("Loading props " + propsFile);
            Properties props = new Properties();
            props.load(new FileInputStream(propsFile));
            return props;
        }
        catch (Exception exp) {
            logger.severe("Unable to load conf file " + propsFile);
            return null;
        }
    }

    public static String getTimeFormat(long datelong) {
        if (datelong == 0L) {
            return "";
        }
        SimpleDateFormat dateformat = new SimpleDateFormat("dd-MM-yyyy hh:mm a");
        return dateformat.format(new Date(datelong));
    }

    public static String getDuration(long time) {
        String timestr = null;
        DecimalFormat numformat = new DecimalFormat("#.##");
        timestr = time > 86400000L ? numformat.format((float)(time * 24L / 86400000L) / 24.0f) + " Days" : (time > 3600000L ? numformat.format((float)(time * 60L / 3600000L) / 60.0f) + " Hours" : (time > 60000L ? numformat.format((float)(time * 60L / 60000L) / 60.0f) + " Minutes" : (time > 1000L ? numformat.format((float)(time * 1000L / 1000L) / 1000.0f) + " Seconds" : time + " Millis")));
        return timestr;
    }

    public static String getMemSize(long sizeInBytes) {
        String size = null;
        size = sizeInBytes > 0x10000000000L ? (float)(sizeInBytes * 100L / 0x10000000000L) / 100.0f + " TB" : (sizeInBytes > 0x40000000L ? (float)(sizeInBytes * 100L / 0x40000000L) / 100.0f + " GB" : (sizeInBytes > 0x100000L ? (float)(sizeInBytes * 100L / 0x100000L) / 100.0f + " MB" : (sizeInBytes > 1024L ? (float)(sizeInBytes * 100L / 1024L) / 100.0f + " KB" : sizeInBytes + " Bytes")));
        return size;
    }

    public static String getCountSize(long count) {
        String size = null;
        size = count > 1000000000L ? (float)(count * 100L / 1000000000L) / 100.0f + " B" : (count > 1000000L ? (float)(count * 100L / 1000000L) / 100.0f + " M" : (count > 1000L ? (float)(count * 100L / 1000L) / 100.0f + " K" : "" + count));
        return size;
    }

    public static String getPercentage(long value, long total) {
        return "" + (float)(value * 10000L / total) / 100.0f;
    }

    public static String getServerIP() {
        return serverIP;
    }

    public static boolean isMiDisabled() {
        return Boolean.parseBoolean(System.getProperty("midisable"));
    }

    public static String getIP(String wnet) {
        return wnet.split(":")[0];
    }

    public static boolean isIPInRange(String ip, String startip, String endip) {
        long ipl = ServerUtil.IP_LONG(ip);
        long startipl = ServerUtil.IP_LONG(startip);
        long endipl = ServerUtil.IP_LONG(endip);
        return ipl <= endipl && ipl >= startipl;
    }

    public static int getThreadPoolCount() {
        return threadPoolCount;
    }

    public static long IP_LONG(String address) {
        int i;
        long laddr = 0L;
        String[] st = address.split("\\.");
        int[] addr = new int[4];
        for (i = 0; i < 4; ++i) {
            addr[i] = Integer.parseInt(st[i]);
        }
        for (i = 0; i < 4; ++i) {
            laddr |= (long)addr[i] << 8 * (3 - i);
        }
        return laddr;
    }

    public static void logExternal(WmsEvent event, String method, String opr) {
        if (eLogger != null && event != null) {
            eLogger.logEvent(event.getDataAsString("reqid"), event.getRPath(), event.getOpr(), event.getRKey(), opr, event.getDataAsString("prd"), null);
        }
    }

    static {
        threadPoolCount = 3;
        serverIP = null;
        eLogger = null;
        eLoggerFile = null;
        serverHome = System.getProperty("server.home");
        logHome = System.getProperty("wmslog.home") == null ? serverHome + File.separator + "wmslogs" + File.separator : System.getProperty("wmslog.home") + File.separator;
        eLoggerFile = serverHome + File.separator + "conf" + File.separator + "elogger.properties";
        dataHome = System.getProperty("wmsdata.home") == null ? serverHome + File.separator + "wmsdata" + File.separator : System.getProperty("wmsdata.home") + File.separator;
        threadPoolCount = Integer.parseInt(System.getProperty("wmsthreads.count", "" + threadPoolCount));
        try {
            serverIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        try {
            Properties eLoggerprops = ServerUtil.getProperties(eLoggerFile);
            if (eLoggerprops != null) {
                eLogger = (ExternalLogger)Class.forName((String)eLoggerprops.get("externallogger")).newInstance();
            }
        }
        catch (Exception es) {
            es.printStackTrace();
        }
    }
}

