/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.GlobalConstants;
import HTTPClient.HTTPClientModule;
import HTTPClient.HTTPConnection;
import HTTPClient.IdempotentSequence;
import HTTPClient.Log;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RetryException;
import HTTPClient.RoRequest;
import HTTPClient.Util;
import java.io.IOException;

class RetryModule
implements HTTPClientModule,
GlobalConstants {
    RetryModule() {
    }

    public int requestHandler(Request req, Response[] resp) {
        return 0;
    }

    public void responsePhase1Handler(Response resp, RoRequest roreq) throws IOException, ModuleException {
        block23: {
            try {
                resp.getStatusCode();
                break block23;
            }
            catch (RetryException re) {
                Log.write(32, "RtryM: Caught RetryException");
                boolean got_lock = false;
                try {
                    RetryException retryException = re.first;
                    synchronized (retryException) {
                        got_lock = true;
                        IdempotentSequence seq = new IdempotentSequence();
                        RetryException e = re.first;
                        while (e != null) {
                            seq.add(e.request);
                            e = e.next;
                        }
                        RetryException e2 = re.first;
                        while (e2 != null) {
                            Log.write(32, "RtryM: handling exception ", e2);
                            Request req = e2.request;
                            HTTPConnection con = req.getConnection();
                            if (!seq.isIdempotent(req) || con.ServProtVersKnown && con.ServerProtocolVersion >= 65537 && req.num_retries > 0 || (!con.ServProtVersKnown || con.ServerProtocolVersion <= 65536) && req.num_retries > 4 || e2.response.got_headers) {
                                e2.first = null;
                            } else if (req.getStream() != null) {
                                if (HTTPConnection.deferStreamed) {
                                    req.getStream().reset();
                                    e2.response.setRetryRequest(true);
                                }
                                e2.first = null;
                            } else {
                                if (req.getData() != null && e2.conn_reset) {
                                    if (con.ServProtVersKnown && con.ServerProtocolVersion >= 65537) {
                                        this.addToken(req, "Expect", "100-continue");
                                    } else {
                                        req.delay_entity = 5000L << req.num_retries;
                                    }
                                }
                                if (e2.next != null && e2.next.request.getData() != null && (!con.ServProtVersKnown || con.ServerProtocolVersion < 65537) && e2.conn_reset) {
                                    this.addToken(req, "Connection", "close");
                                }
                                if (con.ServProtVersKnown && con.ServerProtocolVersion >= 65537 && e2.conn_reset) {
                                    req.dont_pipeline = true;
                                }
                                req.dont_pipeline = true;
                                Log.write(32, "RtryM: Retrying request '" + req.getMethod() + " " + req.getRequestURI() + "'");
                                if (e2.conn_reset) {
                                    ++req.num_retries;
                                }
                                e2.response.http_resp.set(req, con.sendRequest(req, e2.response.timeout));
                                e2.exception = null;
                                e2.first = null;
                            }
                            e2 = e2.next;
                        }
                    }
                }
                catch (NullPointerException npe) {
                    if (got_lock) {
                        throw npe;
                    }
                }
                catch (ParseException pe) {
                    throw new IOException(pe.getMessage());
                }
            }
            if (re.exception != null) {
                throw re.exception;
            }
            re.restart = true;
            throw re;
        }
    }

    public int responsePhase2Handler(Response resp, Request req) {
        req.delay_entity = 0L;
        req.dont_pipeline = false;
        req.num_retries = 0;
        return 10;
    }

    public void responsePhase3Handler(Response resp, RoRequest req) {
    }

    public void trailerHandler(Response resp, RoRequest req) {
    }

    private void addToken(Request req, String hdr, String tok) throws ParseException {
        NVPair[] hdrs = req.getHeaders();
        int idx = 0;
        while (idx < hdrs.length) {
            if (hdrs[idx].getName().equalsIgnoreCase(hdr)) break;
            ++idx;
        }
        if (idx == hdrs.length) {
            hdrs = Util.resizeArray(hdrs, idx + 1);
            hdrs[idx] = new NVPair(hdr, tok);
            req.setHeaders(hdrs);
        } else if (!Util.hasToken(hdrs[idx].getValue(), tok)) {
            hdrs[idx] = new NVPair(hdr, String.valueOf(hdrs[idx].getValue()) + ", " + tok);
        }
    }
}

