/*
 * Decompiled with CFR 0.152.
 */
package asterisk14.com.zohocorp.zoho.ztiimpl.handlers;

import asterisk14.com.zohocorp.zoho.ztiimpl.ConfManager;
import asterisk14.com.zohocorp.zoho.ztiimpl.utils.LRUCache2;
import asterisk14.com.zohocorp.zoho.ztiimpl.utils.ZTICallUtil;
import com.zohocorp.zoho.ztiadapter.ZTIAdapter;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CTICallsHandler2 {
    private static Logger logger = Logger.getLogger(CTICallsHandler2.class.getName());
    private static final HashMap<String, Integer> ZTI_CALLSTATE = new HashMap();
    private static final int IDX_CALLREFID = 0;
    private static final int IDX_FROMNUMBER = 1;
    private static final int IDX_TONUMBER = 2;
    private static final int IDX_CALLSTATE = 3;
    private static final int IDX_CALLTYPE = 4;
    private static final int IDX_RINGINGSTARTEDTIME = 5;
    private static final int IDX_ANSWEREDTIME = 6;
    private static final int IDX_HUNGUPTIME = 7;
    private static final int IDX_CALLDURATION = 8;
    private static final int IDX_OLD_AES_CALLIDS = 9;
    private static final int IDX_UUI = 10;
    private static final int LRUCACHE_SIZE = ConfManager.getLRUCacheSize();
    private LRUCache2<String, Hashtable<Integer, String>> aes_CallIdVsCallDetails = new LRUCache2(LRUCACHE_SIZE);

    public String getCallState(String aesCallId) {
        return this.getCallDetails(aesCallId).get(3);
    }

    public int getCallDuration(String aesCallId) {
        String callDuration = this.getCallDetails(aesCallId).get(8);
        return callDuration != null && Integer.valueOf(callDuration) >= 0 ? Integer.valueOf(callDuration) : -1;
    }

    public CTICallsHandler2 updateCallDetails(String aesCallId, String fromNumber, String toNumber, String callState) {
        if (ZTICallUtil.checkNotNull(fromNumber) && ZTICallUtil.checkNotNull(toNumber) && !fromNumber.equals(toNumber)) {
            String fromZuid = ZTIAdapter.getUserforExtension((String)fromNumber);
            String toZuid = ZTIAdapter.getUserforExtension((String)toNumber);
            if (fromZuid != null || toZuid != null && (fromZuid == null || toZuid == null)) {
                Hashtable<Integer, String> callDetails = this.getCallDetails(aesCallId);
                callDetails.put(0, aesCallId);
                callDetails.put(1, fromNumber);
                callDetails.put(2, toNumber);
                callDetails.put(3, callState);
                callDetails.put(4, fromZuid == null ? "incoming" : "outgoing");
            }
        }
        return this;
    }

    public CTICallsHandler2 updateFromToNumbers(String aesCallId, String fromNumber, String toNumber) {
        if (ZTICallUtil.checkNotNull(fromNumber) && ZTICallUtil.checkNotNull(toNumber) && !fromNumber.equals(toNumber)) {
            String fromZuid = ZTIAdapter.getUserforExtension((String)fromNumber);
            String toZuid = ZTIAdapter.getUserforExtension((String)toNumber);
            if (fromZuid != null || toZuid != null && (fromZuid == null || toZuid == null)) {
                Hashtable<Integer, String> callDetails = this.getCallDetails(aesCallId);
                callDetails.put(0, aesCallId);
                callDetails.put(1, fromNumber);
                callDetails.put(2, toNumber);
                callDetails.put(4, fromZuid == null ? "incoming" : "outgoing");
            }
        }
        return this;
    }

    public void updateFromNumber(String aesCallId, String fromNumber) {
        if (ZTICallUtil.checkNotNull(fromNumber) && ZTIAdapter.getUserforExtension((String)fromNumber) != null) {
            Hashtable<Integer, String> callDetails = this.getCallDetails(aesCallId);
            callDetails.put(1, fromNumber);
        }
    }

    public void updateToNumber(String aesCallId, String toNumber) {
        if (ZTICallUtil.checkNotNull(toNumber) && ZTIAdapter.getUserforExtension((String)toNumber) != null) {
            Hashtable<Integer, String> callDetails = this.getCallDetails(aesCallId);
            callDetails.put(2, toNumber);
        }
    }

    public void updateCallState(String aesCallId, String callState) {
        Hashtable<Integer, String> callDetails = this.getCallDetails(aesCallId);
        long currentTime = System.currentTimeMillis();
        if ("callreceived".equals(callState)) {
            callDetails.put(5, currentTime + "");
        } else if ("callconnected".equals(callState)) {
            callDetails.put(6, currentTime + "");
        } else if ("callended".equals(callState)) {
            String callAnsweredTime = callDetails.get(6);
            Long answeredTime = callAnsweredTime != null ? Long.valueOf(callAnsweredTime) : currentTime;
            long callDuration = (currentTime - answeredTime) / 1000L;
            callDetails.put(7, currentTime + "");
            callDetails.put(8, callDuration + "");
        }
        callDetails.put(3, callState);
        logger.log(Level.INFO, "Handler callDetails ---> {0}", callDetails);
    }

    public void updateCallType(String aesCallId, String callType) {
        Hashtable<Integer, String> callDetails = this.getCallDetails(aesCallId);
        callDetails.put(4, callType);
    }

    public void deleteCallDetails(String aesCallId) {
        this.removeCallDetails(aesCallId);
    }

    public CTICallsHandler2 handleCallStateChange(String aesCallId, String callState) {
        String preCallState = this.getCallState(aesCallId);
        int previousStateInNumber = preCallState != null ? ZTI_CALLSTATE.get(preCallState) : 0;
        int currentStateInNumber = ZTI_CALLSTATE.get(callState);
        if (currentStateInNumber > previousStateInNumber) {
            this.updateCallState(aesCallId, callState);
        } else {
            logger.log(Level.INFO, "previousStateInNumber - {0} & currentStateInNumber - {1} ", new Object[]{previousStateInNumber, currentStateInNumber});
        }
        return this;
    }

    private Hashtable<Integer, String> getCallDetails(String aesCallId) {
        Hashtable callDetails = null;
        callDetails = this.aes_CallIdVsCallDetails.containsKey(aesCallId) ? (Hashtable)this.aes_CallIdVsCallDetails.get(aesCallId) : new Hashtable();
        this.aes_CallIdVsCallDetails.put(aesCallId, callDetails);
        return callDetails;
    }

    private void removeCallDetails(String aesCallId) {
        if (this.aes_CallIdVsCallDetails.containsKey(aesCallId)) {
            Hashtable removedCallDetails = (Hashtable)this.aes_CallIdVsCallDetails.get(aesCallId);
            this.aes_CallIdVsCallDetails.remove(aesCallId);
            logger.log(Level.INFO, "aes_CallIdVsCallDetails & size ---> {0} &", new Object[]{this.aes_CallIdVsCallDetails.size()});
            logger.log(Level.INFO, "removedCallDetails ---> {0}", removedCallDetails);
        }
    }

    static {
        ZTI_CALLSTATE.put("callreceived", 1);
        ZTI_CALLSTATE.put("ringing", 1);
        ZTI_CALLSTATE.put("callinitiated", 2);
        ZTI_CALLSTATE.put("calldialed", 2);
        ZTI_CALLSTATE.put("callanswered", 3);
        ZTI_CALLSTATE.put("callconnected", 3);
        ZTI_CALLSTATE.put("callended", 4);
        ZTI_CALLSTATE.put("callhungup", 4);
        ZTI_CALLSTATE.put("completed", 4);
        ZTI_CALLSTATE.put("callmissed", 5);
    }
}

