/*
 * Decompiled with CFR 0.152.
 */
package asterisk14.com.zohocorp.zoho.ztiimpl;

import asterisk14.com.zohocorp.zoho.ztiimpl.ConfManager;
import asterisk14.com.zohocorp.zoho.ztiimpl.handlers.CTICallsHandler2;
import asterisk14.com.zohocorp.zoho.ztiimpl.utils.LRUCache2;
import com.zohocorp.zoho.ztiadapter.ZohoTeleAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.asteriskjava.live.AsteriskAgent;
import org.asteriskjava.live.AsteriskChannel;
import org.asteriskjava.live.AsteriskQueue;
import org.asteriskjava.live.AsteriskQueueEntry;
import org.asteriskjava.live.AsteriskServer;
import org.asteriskjava.live.AsteriskServerListener;
import org.asteriskjava.live.CallDetailRecord;
import org.asteriskjava.live.CallerId;
import org.asteriskjava.live.ChannelState;
import org.asteriskjava.live.DefaultAsteriskServer;
import org.asteriskjava.live.MeetMeRoom;
import org.asteriskjava.live.MeetMeUser;
import org.asteriskjava.live.internal.AsteriskAgentImpl;

public class ZTIAsterisk14Impl
extends ZohoTeleAdapter {
    private static Logger logger = Logger.getLogger(ZTIAsterisk14Impl.class.getName());
    private static final int LRUCACHE2SIZE = 500;
    private static AsteriskEvents asteriskevents = null;
    private LRUCache2<String, Integer> httpReqIdVsCount;

    public ZTIAsterisk14Impl(String protocol, Integer interval) {
        super(protocol, interval);
    }

    public boolean init(int serverIdx) {
        logger.log(Level.INFO, "ZTIAsterisk14Impl init serverIdx {0}", serverIdx);
        return this.init();
    }

    public boolean init() {
        logger.log(Level.INFO, "ZTIAsterisk14Impl init started {0}", this.getHome());
        if (ConfManager.initialize(this.getHome())) {
            asteriskevents = new AsteriskEvents();
            asteriskevents.run();
            this.httpReqIdVsCount = new LRUCache2(500);
            return true;
        }
        return false;
    }

    protected boolean isLive() {
        return true;
    }

    public boolean makeCall(String fromNumber, String toNumber, Hashtable attachments) {
        logger.log(Level.INFO, "Make Call : fromNumber = {0}, toNumber = {1}, attachments : {2}", new Object[]{fromNumber, toNumber, attachments});
        try {
            String httpReqId = attachments.containsKey("httpReqId") ? attachments.get("httpReqId") + "" : System.currentTimeMillis() + "";
            Integer wmsNotifiedCount = this.httpReqIdVsCount.containsKey(httpReqId) ? (Integer)this.httpReqIdVsCount.get(httpReqId) : Integer.valueOf(0);
            logger.log(Level.INFO, "Make Call wmsNotifiedCount : {0}", wmsNotifiedCount);
            this.httpReqIdVsCount.put(httpReqId, wmsNotifiedCount + 1);
            if (wmsNotifiedCount < 1) {
                asteriskevents.makeCall(fromNumber, "" + attachments.get("fromuser"), toNumber, "" + attachments.get("dialCode"));
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error in makeCall", e);
        }
        return true;
    }

    public boolean endCall(String extn, Hashtable attachments) {
        return true;
    }

    public boolean transferCall(String transferFrom, String transferTo, Hashtable attachments) {
        return true;
    }

    public boolean holdCall(String extn, Hashtable attachments) {
        return true;
    }

    static class AsteriskEvents
    implements AsteriskServerListener,
    PropertyChangeListener {
        private CTICallsHandler2 callsHandler = new CTICallsHandler2();
        private AsteriskServer asteriskServer;
        private static Pattern pDomainNameOnly = Pattern.compile("^((?!-)[A-Za-z0-9-]{1,63}(?<!-)\\.)+[A-Za-z]{2,6}$");
        private static final String DOMAIN_NAME_PATTERN = "^((?!-)[A-Za-z0-9-]{1,63}(?<!-)\\.)+[A-Za-z]{2,6}$";

        public AsteriskEvents() {
            logger.log(Level.INFO, "Asterisk 1.4 - ASTERISK SERVER==> {0}, USERNAME==> {1}, password==> {2}", new Object[]{ConfManager.getServerName(), ConfManager.getManagerUserName(), ConfManager.getManagerPasswd()});
            this.asteriskServer = new DefaultAsteriskServer(ConfManager.getServerName(), ConfManager.getManagerUserName(), ConfManager.getManagerPasswd());
        }

        public void run() {
            logger.log(Level.INFO, "AsteriskEvents run .....");
            try {
                this.asteriskServer.addAsteriskServerListener((AsteriskServerListener)this);
                logger.log(Level.INFO, "Channels {0}", this.asteriskServer.getChannels());
                for (AsteriskChannel asteriskChannel : this.asteriskServer.getChannels()) {
                    logger.log(Level.INFO, "asteriskChannel :--> {0}", asteriskChannel);
                    asteriskChannel.addPropertyChangeListener((PropertyChangeListener)this);
                }
                for (AsteriskQueue asteriskQueue : this.asteriskServer.getQueues()) {
                    logger.log(Level.INFO, "asteriskQueue :--> {0}", asteriskQueue);
                }
                for (MeetMeRoom meetMeRoom : this.asteriskServer.getMeetMeRooms()) {
                    logger.log(Level.INFO, "meetMeRoom :--> {0}", meetMeRoom);
                    for (MeetMeUser user : meetMeRoom.getUsers()) {
                        user.addPropertyChangeListener((PropertyChangeListener)this);
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Error in addAsteriskServerListener or ... ", e);
            }
        }

        public void onNewAsteriskChannel(AsteriskChannel channel) {
            logger.log(Level.INFO, "onNewAsteriskChannel :--> {0}", channel);
            channel.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void onNewMeetMeUser(MeetMeUser user) {
            logger.log(Level.INFO, "onNewMeetMeUser :--> {0}", user);
            user.addPropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Hashtable<String, String> attachments = new Hashtable<String, String>();
            logger.log(Level.INFO, "propertyChangeEvent :--> {0}", propertyChangeEvent);
            this.setCallRecordingPathToChnVariable(propertyChangeEvent);
            AsteriskChannel chn = (AsteriskChannel)propertyChangeEvent.getSource();
            ChannelState chnState = chn.getState();
            String chStat = chnState.toString();
            AsteriskChannel dialedchn = chn.getDialedChannel();
            AsteriskChannel dialingchn = chn.getDialingChannel();
            logger.log(Level.INFO, "Source Channel= {0}, Dialing Channel= {1}, Dialed Channel= {2}", new Object[]{chn, dialingchn, dialedchn});
            CallerId ext = chn.getCallerId();
            String extNumber = ext.getNumber();
            logger.log(Level.INFO, " extNumber : {0} chStat : {1} <--", new Object[]{extNumber, chStat});
            extNumber = this.getIDFromName(chn, extNumber);
            if ("RINGING".equals(chStat)) {
                if (dialingchn != null) {
                    String dateOfCreation = this.getUniqueDateOfCreation(chn.getDateOfCreation(), dialingchn.getDateOfCreation());
                    ext = dialingchn.getCallerId();
                    String fromNumber = ext.getNumber();
                    fromNumber = this.getIDFromName(dialingchn, fromNumber);
                    extNumber = this.getIDFromName(chn, extNumber);
                    String callRefId = ZohoTeleAdapter.ZOHO.generateCallUID(fromNumber, dateOfCreation);
                    logger.log(Level.INFO, "attachments === > {0}", attachments);
                    logger.log(Level.INFO, "ZOHO.callReceived({0}, {1}, {2}, {3}, {4})", new Object[]{callRefId, fromNumber.trim(), extNumber.trim(), dateOfCreation, attachments});
                    this.callsHandler.updateFromToNumbers(callRefId, fromNumber, extNumber).handleCallStateChange(callRefId, "callreceived");
                    ZohoTeleAdapter.ZOHO.callReceived(callRefId, fromNumber.trim(), extNumber.trim(), dateOfCreation, attachments);
                } else {
                    logger.log(Level.INFO, "dialing channel is null. call initiated from code");
                }
            } else if ("UP".equals(chStat)) {
                AsteriskChannel linkedChannel = chn.getLinkedChannel();
                logger.log(Level.INFO, "LINKED CHANNEL ==> {0}", linkedChannel);
                if (linkedChannel != null) {
                    ext = linkedChannel.getCallerId();
                    if (dialedchn != null) {
                        String dateOfCreation = this.getUniqueDateOfCreation(chn.getDateOfCreation(), dialedchn.getDateOfCreation());
                        String toNumber = ext.getNumber();
                        toNumber = this.getIDFromName(linkedChannel, toNumber);
                        String callRefId = ZohoTeleAdapter.ZOHO.generateCallUID(extNumber.trim(), dateOfCreation);
                        logger.log(Level.INFO, "attachments === > {0}", attachments);
                        logger.log(Level.INFO, "ZOHO.callConnected({0}, {1}, {2}, {3}, {4})", new Object[]{callRefId, extNumber.trim(), toNumber.trim(), dateOfCreation, attachments});
                        this.callsHandler.updateFromToNumbers(callRefId, extNumber, extNumber).handleCallStateChange(callRefId, "callconnected");
                        ZohoTeleAdapter.ZOHO.callConnected(callRefId, extNumber.trim(), toNumber.trim(), dateOfCreation, attachments);
                    }
                }
            } else if ("HUNGUP".equals(chStat)) {
                if (dialingchn != null | dialedchn != null) {
                    CallerId callerId = ext = dialingchn != null ? dialingchn.getCallerId() : dialedchn.getCallerId();
                    if (dialedchn != null) {
                        String toNumber = ext.getNumber();
                        toNumber = this.getIDFromName(dialedchn, toNumber);
                        Date validDOC = this.getValidDateOfCreation(chn.getDateOfCreation(), dialedchn.getDateOfCreation());
                        String dateOfCreation = this.getUniqueDateOfCreation(validDOC);
                        String callRefId = ZohoTeleAdapter.ZOHO.generateCallUID(extNumber.trim(), dateOfCreation);
                        this.callsHandler.updateFromToNumbers(callRefId, extNumber.trim(), extNumber).handleCallStateChange(callRefId, "callended");
                        CallDetailRecord cdr = chn.getCallDetailRecord();
                        logger.log(Level.INFO, "Call Detail Record to get billablesec/callduration = {0}", cdr);
                        int billablesec = -1;
                        int callduration = -1;
                        logger.log(Level.INFO, "Call Detail Record => {0}", cdr);
                        if (cdr != null) {
                            try {
                                billablesec = cdr.getBillableSeconds();
                                callduration = cdr.getDuration();
                            }
                            catch (Exception e) {
                                logger.log(Level.INFO, "Error in getting Billable Second & Call Duration. ", e);
                            }
                            logger.log(Level.INFO, "billablesec = {0} , callduration = {1}", new Object[]{billablesec, callduration});
                            if (billablesec == -1 && callduration != -1) {
                                billablesec = callduration;
                            }
                        }
                        if (billablesec == -1) {
                            billablesec = this.callsHandler.getCallDuration(callRefId);
                            logger.log(Level.INFO, "callduration from handler = {0} ", new Object[]{billablesec});
                        }
                        String callRecordingURL = ConfManager.isCallRecordingEnabled() ? this.getCallRecordingURL(this.getCallRecordingPathFromChnVariable(chn)) : "";
                        attachments.put("callRecordingURL", callRecordingURL);
                        logger.log(Level.INFO, "attachments === > {0}", attachments);
                        logger.log(Level.INFO, "ZOHO.callEnded({0}, {1}, {2}, {3}, {4}, {5}) ", new Object[]{callRefId, extNumber.trim(), toNumber.trim(), dateOfCreation, billablesec, attachments});
                        ZohoTeleAdapter.ZOHO.callEnded(callRefId, extNumber.trim(), toNumber.trim(), dateOfCreation, billablesec, attachments);
                    }
                } else {
                    logger.log(Level.INFO, "dialing & dialed channels are null. Hungup for call originated from code by the owner before the receiver accepts");
                }
            } else if ("BUSY".equals(chStat)) {
                logger.log(Level.INFO, " BUSYYYYYYYYYYYYYYYYYY ########");
            } else {
                logger.log(Level.INFO, "{0} - USELESS STATE ... Simply omit ...", chStat);
            }
            logger.log(Level.INFO, "====================================================================================== Process Done.");
        }

        public void makeCall(String fromNumber, String fromUser, String toNumber, String dialCode) throws Exception {
            String outgoingCallContext = ConfManager.getOutGoingCallContext();
            String outboundCallChannel = ConfManager.getOutboundcallchannel();
            if (!"null".equals(dialCode)) {
                toNumber = dialCode + toNumber;
            }
            CallerId fromId = new CallerId(fromUser, fromNumber);
            logger.log(Level.INFO, " Inform Asterisk to Make Call ================= toNumber= {0}, fromNumber= {1}, from User= {2}, fromId= {3}, OutgoingCallContext= {4}, dialCode= {5}.", new Object[]{toNumber, fromNumber, fromUser, fromId, outgoingCallContext, dialCode});
            AsteriskChannel outgoingChn = this.asteriskServer.originateToExtension(outboundCallChannel + "/" + fromUser, outgoingCallContext, toNumber, 1, 30000L, fromId, null);
        }

        public void onNewQueueEntry(AsteriskQueueEntry entry) {
            logger.log(Level.INFO, " onNewQueueEntry : {0}", entry);
        }

        public void onNewAgent(AsteriskAgentImpl entry) {
            logger.log(Level.INFO, " onNewAgent : {0}", entry);
        }

        public String convertDateFormatAndToGMT(Date dateOfCreation) {
            String destFormat = "yyyy-MM-dd hh:mm:ss a";
            try {
                dateOfCreation = AsteriskEvents.convertToGMT(dateOfCreation, "yyyy-MM-dd hh:mm:ss a");
                SimpleDateFormat destDateformat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss a");
                String srcDateStr = destDateformat.format(dateOfCreation);
                return srcDateStr;
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Error in converting TimeZone to GMT & date format. Error=", e);
                return null;
            }
        }

        public static Date convertToGMT(Date fromDate, String stdDateTimeFormat) throws Exception {
            TimeZone fromTZObj = TimeZone.getTimeZone(new SimpleDateFormat("z").format(fromDate));
            TimeZone toTZObj = TimeZone.getTimeZone("GMT");
            Calendar cal = Calendar.getInstance();
            cal.setTime(fromDate);
            GregorianCalendar fromCal = new GregorianCalendar(fromTZObj);
            fromCal.set(cal.get(1), cal.get(2), cal.get(5), cal.get(11), cal.get(12), cal.get(13));
            GregorianCalendar toCal = new GregorianCalendar(toTZObj);
            toCal.setTimeInMillis(fromCal.getTimeInMillis());
            Date dd = toCal.getTime();
            SimpleDateFormat format = new SimpleDateFormat(stdDateTimeFormat, Locale.US);
            format.setTimeZone(toTZObj);
            String ff = format.format(dd);
            SimpleDateFormat formatter = new SimpleDateFormat(stdDateTimeFormat, Locale.US);
            long longff = formatter.parse(ff).getTime();
            Timestamp retDate = new Timestamp(longff);
            return retDate;
        }

        private String getIDFromName(AsteriskChannel chn, String extNumber) {
            logger.log(Level.INFO, "Ext No= {0}, Channel= {1}", new Object[]{extNumber, chn});
            try {
                String chnName = chn.getName().replaceAll("from-queue", "");
                String[] name1 = chnName.split("-");
                String[] name2 = name1[0].split("/");
                if (!name2[1].equals(extNumber)) {
                    if (ZohoTeleAdapter.ZOHO.getUserforExtension(name2[1]) != null) {
                        extNumber = name2[1];
                        logger.log(Level.INFO, "changed Ext No= {0}", extNumber);
                    } else if (extNumber != null && ZohoTeleAdapter.ZOHO.getUserforExtension(extNumber) == null && Pattern.matches("[0-9]*", name2[1]) && !Pattern.matches("[0-9]*", extNumber)) {
                        extNumber = name2[1];
                        logger.log(Level.INFO, "callerid has alphabets but name is numerical so changed Ext No= {0}", extNumber);
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Could not get id from name");
            }
            return extNumber;
        }

        private Date getValidDateOfCreation(Date dateOfCreation1, Date dateOfCreation2) {
            return dateOfCreation1.compareTo(dateOfCreation2) < 0 ? dateOfCreation2 : dateOfCreation1;
        }

        private String getUniqueDateOfCreation(Date dateOfCreation) {
            logger.log(Level.INFO, "Selected Date Of Creation = {0}", dateOfCreation);
            String doc = this.convertDateFormatAndToGMT(dateOfCreation);
            logger.log(Level.INFO, "Converted Date Of Creation  = {0}", doc);
            return doc;
        }

        private String getUniqueDateOfCreation(Date dateOfCreation1, Date dateOfCreation2) {
            String doc = "";
            doc = dateOfCreation1.compareTo(dateOfCreation2) < 0 ? this.convertDateFormatAndToGMT(dateOfCreation2) : this.convertDateFormatAndToGMT(dateOfCreation1);
            logger.log(Level.INFO, "Selected Date Of Creation = {0}", doc);
            return doc;
        }

        public void onNewAgent(AsteriskAgent arg0) {
            logger.log(Level.INFO, "onNewAgent = {0}", arg0);
        }

        private String getCallRecordingURL(String path) {
            logger.log(Level.INFO, "isDevelopement {0} ", ConfManager.isDevelopement());
            String callRecordingURL = "1";
            logger.log(Level.INFO, "CallRecordingPath = {0}", path);
            String domain = ConfManager.getCallRecordingDomain();
            if (domain != null && path != null && !"".equals(domain)) {
                callRecordingURL = (domain.contains("http://") || domain.contains("https://") ? domain : "https://" + domain) + AsteriskEvents.getFolderStructure() + "/" + path;
            }
            return callRecordingURL;
        }

        private static boolean isValidDomainName(String domainName) {
            return pDomainNameOnly.matcher(domainName).find();
        }

        private static String getFolderStructure() {
            String folderStructure = ConfManager.getCallRecordingFolderStructure();
            return folderStructure != null && !"".equals(folderStructure) ? "/" + folderStructure.toLowerCase() : "";
        }

        private void setCallRecordingPathToChnVariable(PropertyChangeEvent propertyChangeEvent) {
            logger.log(Level.INFO, "setCallRecordingPathToChnVariable ------> {0}", propertyChangeEvent.toString());
            try {
                String newVal = propertyChangeEvent.getNewValue() + "";
                if (newVal != null && newVal.indexOf("application='MixMonitor'") != -1) {
                    String callRecordingPath;
                    logger.log(Level.INFO, "setCallRecordingPathToChnVariable newVal ------> {0} ", newVal);
                    String[] tempArr = newVal.split("appData=/var/www/html/");
                    String string = callRecordingPath = tempArr.length >= 1 ? tempArr[1].split(".wav")[0] + ".wav" : null;
                    if (callRecordingPath != null) {
                        AsteriskChannel chn = (AsteriskChannel)propertyChangeEvent.getSource();
                        chn.setVariable("callRecordingPath", callRecordingPath);
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, propertyChangeEvent.toString(), e);
            }
        }

        private String getCallRecordingPathFromChnVariable(AsteriskChannel chn) {
            logger.log(Level.INFO, "getCallRecordingPathFromChnVariable ------> {0}", chn);
            String callRecordingPath = null;
            try {
                if (chn != null) {
                    callRecordingPath = chn.getVariable("callRecordingPath");
                    logger.log(Level.INFO, "getCallRecordingPathFromChnVariable callRecordingPath------> {0}", callRecordingPath);
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error {0}", e);
            }
            return callRecordingPath;
        }
    }
}

