/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.library.setup.metadata;

import com.zoho.crm.library.api.handler.OrganizationAPIHandler;
import com.zoho.crm.library.api.handler.TaxAPIHandler;
import com.zoho.crm.library.api.handler.UserAPIHandler;
import com.zoho.crm.library.api.response.APIResponse;
import com.zoho.crm.library.api.response.BulkAPIResponse;
import com.zoho.crm.library.common.ZCRMEntity;
import com.zoho.crm.library.crud.ZCRMOrgTax;
import com.zoho.crm.library.exception.ZCRMException;
import com.zoho.crm.library.setup.users.ZCRMUser;
import java.util.List;

public class ZCRMOrganization
extends ZCRMEntity {
    private String companyName;
    private String alias;
    private Long orgId;
    private Long primaryZuid;
    private Long zgid;
    private String primaryEmail;
    private String website;
    private String mobile;
    private String phone;
    private String fax;
    private Integer employeeCount;
    private String description;
    private String timeZone;
    private String isoCode;
    private String currencyLocale;
    private String currencySymbol;
    private String street;
    private String state;
    private String city;
    private String country;
    private String zipCode;
    private String countryCode;
    private Boolean mcStatus;
    private Boolean gappsEnabled;
    private Boolean privacySettings;

    private ZCRMOrganization(String orgName, Long orgId) {
        this.companyName = orgName;
        this.orgId = orgId;
    }

    public static ZCRMOrganization getInstance() {
        return new ZCRMOrganization(null, null);
    }

    public static ZCRMOrganization getInstance(String orgName, Long orgId) {
        return new ZCRMOrganization(orgName, orgId);
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Long getPrimaryZuid() {
        return this.primaryZuid;
    }

    public void setPrimaryZuid(Long primaryZuid) {
        this.primaryZuid = primaryZuid;
    }

    public Long getZgid() {
        return this.zgid;
    }

    public void setZgid(Long zgid) {
        this.zgid = zgid;
    }

    public String getPrimaryEmail() {
        return this.primaryEmail;
    }

    public void setPrimaryEmail(String primaryEmail) {
        this.primaryEmail = primaryEmail;
    }

    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public int getEmployeeCount() {
        return this.employeeCount;
    }

    public void setEmployeeCount(Integer employeeCount) {
        this.employeeCount = employeeCount;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String getIsoCode() {
        return this.isoCode;
    }

    public void setIsoCode(String isoCode) {
        this.isoCode = isoCode;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public Boolean getMcStatus() {
        return this.mcStatus;
    }

    public void setMcStatus(Boolean mcStatus) {
        this.mcStatus = mcStatus;
    }

    public Boolean isGappsEnabled() {
        return this.gappsEnabled;
    }

    public void setGappsEnabled(Boolean gappsEnabled) {
        this.gappsEnabled = gappsEnabled;
    }

    public String getCurrencyLocale() {
        return this.currencyLocale;
    }

    public void setCurrencyLocale(String currencyLocale) {
        this.currencyLocale = currencyLocale;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }

    public Boolean isPrivacySettingsEnabled() {
        return this.privacySettings;
    }

    public void setPrivacySettings(Boolean enable) {
        this.privacySettings = enable;
    }

    public BulkAPIResponse getAllUsers() throws ZCRMException {
        return this.getAllUsers(null);
    }

    public BulkAPIResponse getAllUsers(String modifiedSince) throws ZCRMException {
        return UserAPIHandler.getInstance().getAllUsers(modifiedSince, 1, 200);
    }

    public BulkAPIResponse getAllUsers(String modifiedSince, int page, int per_page) throws ZCRMException {
        return UserAPIHandler.getInstance().getAllUsers(modifiedSince, page, per_page);
    }

    public BulkAPIResponse getAllActiveConfirmedUsers() throws ZCRMException {
        return UserAPIHandler.getInstance().getAllActiveConfirmedUsers(1, 200);
    }

    public BulkAPIResponse getAllActiveConfirmedUsers(int page, int per_page) throws ZCRMException {
        return UserAPIHandler.getInstance().getAllActiveConfirmedUsers(page, per_page);
    }

    public BulkAPIResponse getAllAdminUsers() throws ZCRMException {
        return UserAPIHandler.getInstance().getAllAdminUsers(1, 200);
    }

    public BulkAPIResponse getAllAdminUsers(int page, int per_page) throws ZCRMException {
        return UserAPIHandler.getInstance().getAllAdminUsers(page, per_page);
    }

    public BulkAPIResponse getAllActiveUsers() throws ZCRMException {
        return UserAPIHandler.getInstance().getAllActiveUsers(1, 200);
    }

    public BulkAPIResponse getAllActiveUsers(int page, int per_page) throws ZCRMException {
        return UserAPIHandler.getInstance().getAllActiveUsers(page, per_page);
    }

    public BulkAPIResponse getAllInActiveUsers() throws ZCRMException {
        return UserAPIHandler.getInstance().getAllDeactivedUsers(1, 200);
    }

    public BulkAPIResponse getAllInActiveUsers(int page, int per_page) throws ZCRMException {
        return UserAPIHandler.getInstance().getAllDeactivedUsers(page, per_page);
    }

    public APIResponse getUser(Long userId) throws ZCRMException {
        return UserAPIHandler.getInstance().getUser(userId);
    }

    public APIResponse addUser(ZCRMUser user) throws ZCRMException {
        if (user.getId() != null) {
            throw new ZCRMException("User ID MUST be null for create operation.");
        }
        return UserAPIHandler.getInstance().createUser(user);
    }

    private BulkAPIResponse addUsers(List<ZCRMUser> users) throws ZCRMException {
        if (users == null || users.isEmpty()) {
            throw new ZCRMException("User list MUST NOT be null for create operation.");
        }
        return UserAPIHandler.getInstance().createUsers(users);
    }

    public APIResponse updateUser(ZCRMUser user) throws ZCRMException {
        if (user.getId() == null) {
            throw new ZCRMException("User ID MUST NOT be null/empty for update operation.");
        }
        return UserAPIHandler.getInstance().updateUser(user);
    }

    private BulkAPIResponse updateUsers(List<ZCRMUser> users) throws ZCRMException {
        if (users == null || users.isEmpty()) {
            throw new ZCRMException("User list MUST NOT be null/empty for update operation.");
        }
        return UserAPIHandler.getInstance().updateUsers(users);
    }

    public APIResponse deleteUser(Long userId) throws ZCRMException {
        if (userId == null) {
            throw new ZCRMException("Entity ID MUST NOT be null for delete operation.");
        }
        return UserAPIHandler.getInstance().deleteUser(userId);
    }

    private BulkAPIResponse searchUserByCriteria(String searchCriteria) throws ZCRMException {
        return this.searchUserByCriteria(searchCriteria, 1, 200);
    }

    private BulkAPIResponse searchUserByCriteria(String searchCriteria, int page, int per_page) throws ZCRMException {
        return UserAPIHandler.getInstance().searchByCriteria(searchCriteria, page, per_page);
    }

    public BulkAPIResponse getAllRoles() throws ZCRMException {
        return OrganizationAPIHandler.getInstance().getAllRoles();
    }

    public APIResponse getRole(Long roleId) throws ZCRMException {
        return OrganizationAPIHandler.getInstance().getRole(roleId);
    }

    public BulkAPIResponse getAllProfiles() throws ZCRMException {
        return OrganizationAPIHandler.getInstance().getAllProfiles();
    }

    public APIResponse getProfile(Long profileId) throws ZCRMException {
        return OrganizationAPIHandler.getInstance().getProfile(profileId);
    }

    public BulkAPIResponse getAllTaxes() throws ZCRMException {
        return TaxAPIHandler.getInstance().getAllTaxes();
    }

    public APIResponse getTax(Long taxId) throws ZCRMException {
        return TaxAPIHandler.getInstance().getTax(taxId);
    }

    private BulkAPIResponse createTaxes(List<ZCRMOrgTax> taxes) throws ZCRMException {
        for (ZCRMOrgTax tax : taxes) {
            if (tax.getId() == null) continue;
            throw new ZCRMException("Tax ID MUST be null for create operation.");
        }
        return TaxAPIHandler.getInstance().createTaxes(taxes);
    }

    private BulkAPIResponse updateTaxes(List<ZCRMOrgTax> taxes) throws ZCRMException {
        for (ZCRMOrgTax tax : taxes) {
            if (tax.getId() != null) continue;
            throw new ZCRMException("Tax ID MUST NOT be null for update operation.");
        }
        return TaxAPIHandler.getInstance().updateTaxes(taxes);
    }

    private BulkAPIResponse deleteTaxes(List<Long> taxIds) throws ZCRMException {
        if (taxIds == null || taxIds.isEmpty()) {
            throw new ZCRMException("Tax ID list MUST NOT be null/empty for delete operation.");
        }
        return TaxAPIHandler.getInstance().deleteTaxes(taxIds);
    }
}

