/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.library.exception;

import com.zoho.crm.library.api.APIConstants;
import com.zoho.crm.library.common.ZCRMConfigUtil;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ZCRMLogger {
    private static Logger logger;

    public static void initLogger() {
        logger = Logger.getLogger(ZCRMLogger.class.getName());
        String minLogLevel = ZCRMConfigUtil.getConfigValue("minLogLevel");
        if (minLogLevel == null || !APIConstants.LOGGER_LEVELS.containsKey(minLogLevel)) {
            logger.setLevel(Level.WARNING);
        } else if (APIConstants.LOGGER_LEVELS.containsKey(minLogLevel)) {
            logger.setLevel(APIConstants.LOGGER_LEVELS.get(minLogLevel));
        }
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void logDebug(String message) {
        logger.log(Level.FINE, "ZCRM - " + message);
    }

    public static void logInfo(String message) {
        logger.log(Level.INFO, "ZCRM - " + message);
    }

    public static void logWarning(String message) {
        logger.log(Level.WARNING, "ZCRM - " + message);
    }

    public static void logError(String message) {
        logger.log(Level.SEVERE, "ZCRM - " + message);
    }

    public static void logError(Throwable ex) {
        ZCRMLogger.logError(ex, false);
    }

    public static void logError(Throwable ex, boolean printStackTrace) {
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        StackTraceElement element = stacktrace[3];
        String className = element.getClassName();
        String methodName = element.getMethodName();
        int lineNumber = element.getLineNumber();
        String methodClause = className + '.' + methodName + ':' + lineNumber;
        logger.log(Level.SEVERE, "ZCRM -  in " + methodClause + " ::: " + ex);
        if (printStackTrace) {
            ex.printStackTrace();
        }
    }
}

