/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.library.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;

public final class APIConstants {
    public static final String REMAINING_COUNT_FOR_THIS_DAY = "X-RATELIMIT-LIMIT";
    public static final String REMAINING_COUNT_FOR_THIS_WINDOW = "X-RATELIMIT-REMAINING";
    public static final String REMAINING_TIME_FOR_WINDOW_RESET = "X-RATELIMIT-RESET";
    public static final String URL = "URL";
    public static final String HEADERS = "HEADERS";
    public static final String PARAMS = "PARAMS";
    public static final String STATUS_CODE = "STATUS_CODE";
    public static final String RESPONSE_JSON = "RESPONSE_JSON";
    public static final String RESPONSE_HEADERS = "RESPONSE_HEADERS";
    public static final String EXCEPTION_LOG_MSG = "ZCRM - ";
    public static final String SDK_ERROR = "ZCRM_INTERNAL_ERROR";
    public static final String AUTHENTICATION_FAILURE = "AUTHENTICATION_FAILURE";
    public static String authHeaderPrefix = "Zoho-oauthtoken ";
    public static final String CODE_ERROR = "error";
    public static final String CODE_SUCCESS = "success";
    public static final String MESSAGE = "message";
    public static final String CODE = "code";
    public static final String STATUS = "status";
    public static final String DETAILS = "details";
    public static final String DATA = "data";
    public static final String INFO = "info";
    public static final String PRIVATE_FIELDS = "private_fields";
    public static final String TRIGGER = "trigger";
    public static final String PER_PAGE = "per_page";
    public static final String PAGE = "page";
    public static final String COUNT = "count";
    public static final String MORE_RECORDS = "more_records";
    public static final String LEADS = "Leads";
    public static final String ACCOUNTS = "Accounts";
    public static final String CONTACTS = "Contacts";
    public static final String DEALS = "Deals";
    public static final String QUOTES = "Quotes";
    public static final String SALESORDERS = "SalesOrders";
    public static final String INVOICES = "Invoices";
    public static final String PURCHASEORDERS = "PurchaseOrders";
    public static final String INVALID_ID_MSG = "The given id seems to be invalid.";
    public static final String INVALID_DATA = "INVALID_DATA";
    public static final String API_MAX_RECORDS_MSG = "Cannot process more than 100 records at a time.";
    public static final String ACTION = "action";
    public static final String DUPLICATE_FIELD = "duplicate_field";
    public static final String GMT = "GMT";
    public static final String MIN_LOG_LEVEL = "minLogLevel";
    public static final String DOMAIN_SUFFIX = "domainSuffix";
    public static final String ACCESS_TYPE = "accessType";
    public static final String API_BASE_URL = "apiBaseUrl";
    public static final int MAX_ALLOWED_FILE_SIZE_IN_MB = 20;
    public static final ArrayList<String> CONVERTIBLE_MODULES = new ArrayList<String>(Arrays.asList("Leads", "Quotes", "SalesOrders"));
    public static final ArrayList<String> PROPERTIES_AS_FILEDS = new ArrayList<String>(Arrays.asList("se_module", "gclid"));
    public static ArrayList<ResponseCode> faultyResponseCodes = new ArrayList();
    public static final HashMap<String, Level> LOGGER_LEVELS;
    public static final HashMap<String, String> ACCESS_TYPES;

    static {
        faultyResponseCodes.add(ResponseCode.NO_CONTENT);
        faultyResponseCodes.add(ResponseCode.NOT_FOUND);
        faultyResponseCodes.add(ResponseCode.AUTHORIZATION_ERROR);
        faultyResponseCodes.add(ResponseCode.BAD_REQUEST);
        faultyResponseCodes.add(ResponseCode.FORBIDDEN);
        faultyResponseCodes.add(ResponseCode.INTERNAL_SERVER_ERROR);
        faultyResponseCodes.add(ResponseCode.METHOD_NOT_ALLOWED);
        faultyResponseCodes.add(ResponseCode.MOVED_PERMANENTLY);
        faultyResponseCodes.add(ResponseCode.MOVED_TEMPORARILY);
        faultyResponseCodes.add(ResponseCode.REQUEST_ENTITY_TOO_LARGE);
        faultyResponseCodes.add(ResponseCode.TOO_MANY_REQUEST);
        faultyResponseCodes.add(ResponseCode.UNSUPPORTED_MEDIA_TYPE);
        LOGGER_LEVELS = new HashMap();
        LOGGER_LEVELS.put("ALL", Level.ALL);
        LOGGER_LEVELS.put("FINEST", Level.FINEST);
        LOGGER_LEVELS.put("TRACE", Level.FINER);
        LOGGER_LEVELS.put("DEBUG", Level.FINE);
        LOGGER_LEVELS.put("CONFIG", Level.CONFIG);
        LOGGER_LEVELS.put("INFO", Level.INFO);
        LOGGER_LEVELS.put("WARNING", Level.WARNING);
        LOGGER_LEVELS.put("ERROR", Level.SEVERE);
        LOGGER_LEVELS.put("OFF", Level.OFF);
        ACCESS_TYPES = new HashMap();
        ACCESS_TYPES.put("Production", "www");
        ACCESS_TYPES.put("Development", "developer");
        ACCESS_TYPES.put("Sandbox", "sandbox");
    }

    public static enum ResponseCode {
        OK(200),
        CREATED(201),
        ACCEPTED(202),
        NO_CONTENT(204),
        MOVED_PERMANENTLY(301),
        MOVED_TEMPORARILY(302),
        NOT_MODIFIED(304),
        BAD_REQUEST(400),
        AUTHORIZATION_ERROR(401),
        FORBIDDEN(403),
        NOT_FOUND(404),
        METHOD_NOT_ALLOWED(405),
        REQUEST_ENTITY_TOO_LARGE(413),
        UNSUPPORTED_MEDIA_TYPE(415),
        TOO_MANY_REQUEST(429),
        INTERNAL_SERVER_ERROR(500);

        int code;

        private ResponseCode(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static ResponseCode getEnum(int code) {
            switch (code) {
                case 200: {
                    return OK;
                }
                case 201: {
                    return CREATED;
                }
                case 202: {
                    return ACCEPTED;
                }
                case 204: {
                    return NO_CONTENT;
                }
                case 301: {
                    return MOVED_PERMANENTLY;
                }
                case 302: {
                    return MOVED_TEMPORARILY;
                }
                case 304: {
                    return NOT_MODIFIED;
                }
                case 400: {
                    return BAD_REQUEST;
                }
                case 401: {
                    return AUTHORIZATION_ERROR;
                }
                case 403: {
                    return FORBIDDEN;
                }
                case 404: {
                    return NOT_FOUND;
                }
                case 405: {
                    return METHOD_NOT_ALLOWED;
                }
                case 413: {
                    return REQUEST_ENTITY_TOO_LARGE;
                }
                case 415: {
                    return UNSUPPORTED_MEDIA_TYPE;
                }
                case 429: {
                    return TOO_MANY_REQUEST;
                }
                case 500: {
                    return INTERNAL_SERVER_ERROR;
                }
            }
            return null;
        }
    }

    public static enum RequestMethod {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

