/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.creator.client.tool;

import com.zoho.creator.client.common.FileOperations;
import com.zoho.creator.client.common.OAuth2Util;
import com.zoho.creator.client.tool.util.ToolUtil;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class ConsoleObjectNew
extends Thread {
    private static String scopeName;
    private static String appLinkName;
    private static JSONObject fieldDetails;
    private static String formLinkName;
    private static String requestUrl;
    private static String responseDataString;
    private static JSONObject responseDataJson;
    private static File inputFile;
    private static String inputFilePath;
    private static String criteriaField;
    private static String serviceUrl;
    private static String appAction;
    private static String formAction;
    private static float splittedFileCount;
    private static float processedFileCount;
    private static List<File> splittedFiles;
    private static int errorCount;
    private static String errorResponsePath;
    private static Logger logger;
    private static PostMethod postMethod;
    private static final HttpClient HTTP_CLIENT;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws Exception {
        if (!args[0].trim().equals("-clear")) {
            serviceUrl = OAuth2Util.getServiceUrl();
            inputFilePath = args[0].trim();
            inputFile = new File(inputFilePath);
            scopeName = OAuth2Util.getOwnerName();
            if (scopeName.equals("")) {
                throw new Exception("Invalid Ownername");
            }
            if (!inputFile.isFile()) {
                throw new Exception("File not found.");
            }
            if (!FilenameUtils.getExtension((String)inputFilePath).equals("csv")) {
                throw new Exception("Invalid File Type. Pass the valid Comma Seperated Value File(.csv)");
            }
            appAction = args[1].trim();
            if (!appAction.equals("-e")) {
                throw new Exception("Invalid App Action.");
            }
            appLinkName = args[2].trim();
            if (appLinkName.equals("")) {
                throw new Exception("Invalid App Link Name.");
            }
            formAction = args[3].trim();
            if (!formAction.equals("-a") && !formAction.equals("-au")) {
                throw new Exception("Invalid Form Action.");
            }
            formLinkName = args[4].trim();
            if (formLinkName.equals("")) {
                throw new Exception("Invalid Form Name.");
            }
            ConsoleObjectNew.accumulateFormFields();
            if (formAction.equals("-au")) {
                criteriaField = args[5].trim();
                if (criteriaField.equals("")) throw new Exception("Criteria Field not found in Command.");
                ConsoleObjectNew.accumulateFormFields();
                if (!fieldDetails.has(criteriaField)) throw new Exception("Invalid Criteria Field.");
                JSONObject fieldObj = fieldDetails.getJSONObject(criteriaField);
                if (!fieldObj.has("unique") || !fieldObj.getBoolean("unique")) {
                    throw new Exception("Unique Colmun only can be passed as Criteria Column.");
                }
                ConsoleObjectNew.addOrUpdateRecords();
                return;
            } else {
                ConsoleObjectNew.addRecords();
            }
            return;
        } else {
            OAuth2Util.logout();
        }
    }

    private static void accumulateFormFields() throws Exception {
        requestUrl = serviceUrl + "/api/v2/" + scopeName + "/" + appLinkName + "/form/" + formLinkName + "/fields";
        ConsoleObjectNew.getRequest();
        if (responseDataJson.getInt("code") == 3000) {
            fieldDetails = new JSONObject();
            JSONArray fieldJSONArray = responseDataJson.getJSONArray("fields");
            for (int i = 1; i <= fieldJSONArray.length(); ++i) {
                JSONObject fieldObj = fieldJSONArray.getJSONObject(i - 1);
                fieldDetails.put(fieldObj.getString("link_name"), (Object)fieldObj);
            }
        } else {
            throw new Exception(responseDataJson.toString());
        }
    }

    private static void addRecords() throws Exception {
        requestUrl = serviceUrl + "/importdataapi.do";
        splittedFiles = FileOperations.getSplittedFilesCSVFiles(inputFile);
        splittedFileCount = splittedFiles.size();
        processedFileCount = 0.0f;
        ConsoleObjectNew thread = new ConsoleObjectNew();
        thread.start();
        ConsoleObjectNew.showProgress();
    }

    private static void addOrUpdateRecords() throws Exception {
        requestUrl = serviceUrl + "/xmlrpcapiaction.do";
        splittedFiles = FileOperations.getSplittedXMLFilesFromCSVFile(appLinkName, formLinkName, criteriaField, inputFile);
        splittedFileCount = splittedFiles.size();
        processedFileCount = 0.0f;
        ConsoleObjectNew thread = new ConsoleObjectNew();
        thread.start();
        ConsoleObjectNew.showProgress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            errorResponsePath = "../error/" + System.currentTimeMillis();
            errorCount = 0;
            FileOperations.makeDirectory(errorResponsePath);
            if (formAction.equals("-a")) {
                for (File csvFile : splittedFiles) {
                    Part[] paramsPart = new Part[]{new StringPart("applinkname", appLinkName), new StringPart("formname", formLinkName), new StringPart("isResFileHeader", "true"), new StringPart("zc_ownername", scopeName), new StringPart("SKIP_ONSUBMIT", "true"), new StringPart("SKIP_ONCOMMIT", "true"), new StringPart("SKIP_ONUPDATE", "true"), new StringPart("FILE_DATEFORMAT", "DMY"), new FilePart("importfile", csvFile)};
                    postMethod = new PostMethod(requestUrl);
                    postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(paramsPart, postMethod.getParams()));
                    postMethod.addRequestHeader("Authorization", "Zoho-oauthtoken " + OAuth2Util.getAccessToken());
                    postMethod.addRequestHeader("AGENT-TYPE", "ZohoCreator - JavaUploadTool");
                    HTTP_CLIENT.executeMethod((HttpMethod)postMethod);
                    InputStream is = postMethod.getResponseBodyAsStream();
                    responseDataString = IOUtils.toString((InputStream)is, (String)"UTF-8");
                    responseDataJson = new JSONObject(responseDataString);
                    if (responseDataJson.getString("status").equalsIgnoreCase("Failure")) {
                        FileOperations.createFile(responseDataString, errorResponsePath + "/error" + errorCount + ".json");
                        ++errorCount;
                    }
                    is.close();
                    FileOperations.deleteFile(csvFile);
                    processedFileCount += 1.0f;
                }
            } else if (formAction.equals("-au")) {
                for (File xmlFile : splittedFiles) {
                    Part[] paramsPart = new Part[]{new StringPart("zc_ownername", scopeName), new StringPart("XMLString", new Scanner(xmlFile).nextLine()), new StringPart("criteriaColumn", criteriaField)};
                    postMethod = new PostMethod(requestUrl);
                    postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(paramsPart, postMethod.getParams()));
                    postMethod.addRequestHeader("Authorization", "Zoho-oauthtoken " + OAuth2Util.getAccessToken());
                    postMethod = new PostMethod(requestUrl);
                    postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(paramsPart, postMethod.getParams()));
                    postMethod.addRequestHeader("Authorization", "Zoho-oauthtoken " + OAuth2Util.getAccessToken());
                    postMethod.addRequestHeader("AGENT-TYPE", "ZohoCreator - JavaUploadTool");
                    HTTP_CLIENT.executeMethod((HttpMethod)postMethod);
                    InputStream is = postMethod.getResponseBodyAsStream();
                    responseDataString = IOUtils.toString((InputStream)is, (String)"UTF-8");
                    if (!responseDataString.contains("<status>Success")) {
                        FileOperations.createFile(responseDataString, errorResponsePath + "/error" + errorCount + ".xml");
                        ++errorCount;
                    }
                    is.close();
                    FileOperations.deleteFile(xmlFile);
                    processedFileCount += 1.0f;
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage());
        }
        finally {
            HTTP_CLIENT.getHttpConnectionManager().closeIdleConnections(0L);
        }
    }

    private static void getRequest() throws Exception {
        GetMethod getMethod = new GetMethod(requestUrl);
        getMethod.addRequestHeader("Authorization", "Zoho-oauthtoken " + OAuth2Util.getAccessToken());
        HTTP_CLIENT.executeMethod((HttpMethod)getMethod);
        InputStream is = getMethod.getResponseBodyAsStream();
        responseDataString = IOUtils.toString((InputStream)is, (String)"UTF-8");
        is.close();
        HTTP_CLIENT.getHttpConnectionManager().closeIdleConnections(0L);
        responseDataJson = new JSONObject(responseDataString);
    }

    private static void showProgress() throws Exception {
        int i = 0;
        String progressContent = "";
        ToolUtil.newLine();
        while (splittedFileCount >= processedFileCount) {
            if (splittedFileCount > processedFileCount) {
                if (i == 0) {
                    int progress = (int)((double)(processedFileCount / splittedFileCount) * 100.0);
                    progressContent = "Uploading " + progress + "% ";
                    ToolUtil.showMessage("\r" + progressContent);
                } else {
                    Thread.sleep(100L);
                    ToolUtil.showMessage(".");
                }
                if (++i != 20) continue;
                ToolUtil.showMessage("\r");
                for (int j = 0; j < progressContent.length() + 20; ++j) {
                    ToolUtil.showMessage(" ");
                }
                i = 0;
                continue;
            }
            if (errorCount == 0) {
                FileOperations.removeDirectory(errorResponsePath);
                ToolUtil.showMessageWithNewLine("\rData Uploaded Successfully!!");
                ToolUtil.newLine();
                break;
            }
            ToolUtil.showMessageWithNewLine("\rData Uploaded not properly. Check Error Responses in the Directory : " + errorResponsePath);
            ToolUtil.newLine();
            break;
        }
        ToolUtil.newLine();
    }

    static {
        logger = Logger.getLogger(ConsoleObjectNew.class.getName());
        HTTP_CLIENT = new HttpClient();
    }
}

