/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.creator.client.common;

import com.zoho.creator.client.common.FileOperations;
import com.zoho.creator.client.common.ZohoConstants;
import com.zoho.creator.client.tool.util.ToolUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.io.IOUtils;
import org.json.JSONObject;

public class OAuth2Util {
    private static Scanner scanner;
    private static String ownerName;
    private static String serviceUrl;
    private static Logger logger;

    public static Map<String, String> getAuthorizationMap() throws Exception {
        HashMap<String, String> authorizationMap = new HashMap<String, String>();
        authorizationMap.put("Authorization", "Zoho-oauthtoken " + OAuth2Util.getAccessToken());
        return authorizationMap;
    }

    public static String getAccessToken() throws Exception {
        File accessTokenFileObj = new File("../conf/connection_credentials.json");
        if (accessTokenFileObj.exists()) {
            scanner = new Scanner(accessTokenFileObj);
            String jsonFileContent = scanner.nextLine();
            JSONObject fileContentJSON = new JSONObject(jsonFileContent);
            Long createdTimeMinutes = fileContentJSON.getLong("created_time_milli_seconds") / 1000L / 60L;
            int expiresInMinutes = fileContentJSON.getInt("expires_in") / 60;
            Long expiryTimeMinutes = createdTimeMinutes + (long)expiresInMinutes;
            Long currentTimeMinutes = System.currentTimeMillis() / 1000L / 60L;
            if (expiryTimeMinutes > currentTimeMinutes) {
                return fileContentJSON.getString("access_token");
            }
            return OAuth2Util.generateAndStoreAccessToken(fileContentJSON).getString("access_token");
        }
        return OAuth2Util.generateAndStoreAccessToken(new JSONObject()).getString("access_token");
    }

    public static String getServiceUrl() {
        return serviceUrl;
    }

    public static String getOwnerName() {
        return ownerName;
    }

    public static void loadBasicDetails() throws Exception {
        JSONObject clientContentJson;
        File clientDetails = new File("../conf/connection_credentials.json");
        if (clientDetails.exists()) {
            scanner = new Scanner(clientDetails);
            clientContentJson = new JSONObject(scanner.nextLine());
        } else {
            clientContentJson = OAuth2Util.generateAndStoreAccessToken(new JSONObject());
        }
        ownerName = clientContentJson.getString("owner_name");
        serviceUrl = clientContentJson.getString("creator_url");
        scanner.close();
    }

    public static void logout() {
        new File("../conf/connection_credentials.json").delete();
        ToolUtil.newLine();
        ToolUtil.showMessageWithNewLine("Client Details cleared successfully!!");
        ToolUtil.newLine();
    }

    private static JSONObject generateAndStoreAccessToken(JSONObject clientCredentials) throws Exception {
        Part[] paramsPart = new Part[4];
        if (clientCredentials.length() > 0) {
            paramsPart[0] = new StringPart("grant_type", "refresh_token");
            paramsPart[1] = new StringPart("refresh_token", clientCredentials.getString("refresh_token"));
        } else {
            FileOperations.createConfDirectory();
            scanner = new Scanner(System.in);
            ToolUtil.requireInput("\n1. .com\n2. .eu\n3. .com.cn\n4. .in\n5. .com.au\n\nChoose your DC : ");
            String dcKey = Integer.toString(scanner.nextInt());
            clientCredentials.put("iam_url", (Object)(ZohoConstants.getIAMUrl(dcKey) + "/oauth/v2/token"));
            clientCredentials.put("creator_url", (Object)ZohoConstants.getCreatorUrl(dcKey));
            ToolUtil.requireInput("Enter Owner Name : ");
            clientCredentials.put("owner_name", (Object)scanner.next());
            ToolUtil.requireInput("Enter Client ID : ");
            clientCredentials.put("client_id", (Object)scanner.next());
            ToolUtil.requireInput("Enter Client Secret : ");
            clientCredentials.put("client_secret", (Object)scanner.next());
            ToolUtil.requireInput("Enter Authorization Code : ");
            paramsPart[0] = new StringPart("code", scanner.next());
            paramsPart[1] = new StringPart("grant_type", "authorization_code");
        }
        paramsPart[2] = new StringPart("client_id", clientCredentials.getString("client_id"));
        paramsPart[3] = new StringPart("client_secret", clientCredentials.getString("client_secret"));
        String requestUrl = clientCredentials.getString("iam_url");
        HttpClient httpClient = new HttpClient();
        PostMethod postMethod = new PostMethod(requestUrl);
        postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(paramsPart, postMethod.getParams()));
        httpClient.executeMethod((HttpMethod)postMethod);
        InputStream is = postMethod.getResponseBodyAsStream();
        String responseString = IOUtils.toString((InputStream)is, (String)"UTF-8");
        httpClient.getHttpConnectionManager().closeIdleConnections(0L);
        JSONObject responseJSON = new JSONObject(responseString);
        responseJSON.put("created_time_milli_seconds", System.currentTimeMillis());
        if (!responseJSON.has("access_token")) {
            throw new Exception("Something went wrong. Try again.");
        }
        Iterator jsonKeys = clientCredentials.keys();
        while (jsonKeys.hasNext()) {
            String jsonKey = (String)jsonKeys.next();
            if (responseJSON.has(jsonKey)) continue;
            responseJSON.put(jsonKey, (Object)clientCredentials.getString(jsonKey));
        }
        FileWriter accessTokenFileWriter = new FileWriter("../conf/connection_credentials.json");
        accessTokenFileWriter.write(responseJSON.toString());
        accessTokenFileWriter.close();
        return responseJSON;
    }

    static {
        logger = Logger.getLogger(OAuth2Util.class.getName());
        try {
            OAuth2Util.loadBasicDetails();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage());
        }
    }
}

