/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.creator.client.common;

import au.com.bytecode.opencsv.CSVReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class FileOperations {
    private static List<File> fileList;

    public static List<File> getSplittedFilesCSVFiles(File inputFile) throws Exception {
        fileList = new ArrayList<File>();
        List<String[]> csvRows = FileOperations.getCSVRows(inputFile);
        Object[] headerArr = csvRows.get(0);
        csvRows.remove(0);
        int rowsCount = csvRows.size();
        float noOfFilesRequired = (float)((double)rowsCount / 3000.0);
        noOfFilesRequired = (float)Math.ceil(noOfFilesRequired);
        if (noOfFilesRequired > 1.0f) {
            int fromIndex = 0;
            int toIndex = 3000;
            String headerStr = Arrays.toString(headerArr);
            headerStr = headerStr.substring(1, headerStr.length() - 1).replaceAll(", ", ",");
            StringBuilder csvStringBuilder = new StringBuilder();
            int i = 0;
            while ((float)i < noOfFilesRequired) {
                toIndex = rowsCount < toIndex ? rowsCount : toIndex;
                csvStringBuilder.append(headerStr + "\n");
                for (Object[] objectArray : csvRows.subList(fromIndex, toIndex)) {
                    String rowStr = Arrays.toString(objectArray);
                    rowStr = rowStr.substring(1, rowStr.length() - 1).replaceAll(", ", ",");
                    csvStringBuilder.append(rowStr + "\n");
                }
                FileOperations.addFileToList(csvStringBuilder.toString(), "../temp/dataFile" + i + ".csv");
                csvStringBuilder = new StringBuilder();
                fromIndex += 3000;
                toIndex += 3000;
                ++i;
            }
        } else {
            File oldFile = new File("../temp/" + inputFile.getName());
            if (oldFile.exists()) {
                oldFile.delete();
            }
            File tempDirectory = new File("../temp");
            FileUtils.copyFileToDirectory((File)inputFile, (File)tempDirectory);
            fileList.add(new File("../temp/" + inputFile.getName()));
        }
        return fileList;
    }

    public static List<File> getSplittedXMLFilesFromCSVFile(String appLinkName, String formLinkName, String criteriaField, File inputFile) throws Exception {
        fileList = new ArrayList<File>();
        List<String[]> csvRows = FileOperations.getCSVRows(inputFile);
        String[] headerArr = csvRows.get(0);
        for (int i = 0; i < headerArr.length; ++i) {
            headerArr[i] = headerArr[i].trim().replaceAll(" ", "_");
        }
        csvRows.remove(0);
        int fileCount = 0;
        StringBuilder xmlStringBuilder = new StringBuilder();
        xmlStringBuilder.append("<ZohoCreator><applicationlist><application name=\"" + appLinkName + "\"><formlist><form name=\"" + formLinkName + "\">");
        for (String[] row : csvRows) {
            xmlStringBuilder.append("<addorupdate>");
            for (int i = 0; i < row.length; ++i) {
                xmlStringBuilder.append("<field name=\"" + headerArr[i] + "\"><value><![CDATA[" + row[i].trim() + "]]></value></field>");
            }
            xmlStringBuilder.append("</addorupdate>");
            if (xmlStringBuilder.length() < 1450000) continue;
            xmlStringBuilder.append("</form></formlist></application></applicationlist></ZohoCreator>");
            FileOperations.addFileToList(xmlStringBuilder.toString(), "../temp/dataFile" + fileCount + ".xml");
            xmlStringBuilder = new StringBuilder();
            xmlStringBuilder.append("<ZohoCreator><applicationlist><application name=\"" + appLinkName + "\"><formlist><form name=\"" + formLinkName + "\">");
            ++fileCount;
        }
        xmlStringBuilder.append("</form></formlist></application></applicationlist></ZohoCreator>");
        FileOperations.addFileToList(xmlStringBuilder.toString(), "../temp/dataFile" + fileCount + ".xml");
        return fileList;
    }

    public static void deleteFile(File file) {
        file.delete();
    }

    public static void makeDirectory(String path) {
        new File(path).mkdir();
    }

    public static void removeDirectory(String path) {
        new File(path).delete();
    }

    public static void createFile(String fileContent, String filePath) throws Exception {
        FileWriter fileWriter = new FileWriter(filePath);
        fileWriter.write(fileContent.toString());
        fileWriter.close();
    }

    protected static void createConfDirectory() {
        File tempDirectory = new File("../conf");
        if (!tempDirectory.exists()) {
            tempDirectory.mkdir();
        }
    }

    private static void createTempDirectory() {
        File tempDirectory = new File("../temp");
        if (!tempDirectory.exists()) {
            tempDirectory.mkdir();
        }
    }

    private static void createErrorDirectory() {
        File tempDirectory = new File("../error");
        if (!tempDirectory.exists()) {
            tempDirectory.mkdir();
        }
    }

    private static List<String[]> getCSVRows(File inputFile) throws Exception {
        FileReader fileReader = new FileReader(inputFile);
        char delimiter = ',';
        char qualifier = '\"';
        char escape = '\\';
        CSVReader csvReader = new CSVReader((Reader)fileReader, delimiter, qualifier, escape);
        List csvRows = csvReader.readAll();
        csvReader.close();
        return csvRows;
    }

    private static void addFileToList(String fileContent, String filePath) throws Exception {
        FileWriter fileWriter = new FileWriter(filePath);
        fileWriter.write(fileContent.toString());
        fileWriter.close();
        fileList.add(new File(filePath));
    }

    static {
        FileOperations.createTempDirectory();
        FileOperations.createErrorDirectory();
    }
}

